<?php

/*

Plugin Name: Real-Time Find and Replace Pro

Version: 4.0.3

Plugin URI: http://infolific.com/technology/software-worth-using/real-time-find-and-replace-for-wordpress/

Description: Set up find and replace rules that are executed AFTER a page is generated by WordPress, but BEFORE it is sent to a user's browser.

Author: Marios Alexandrou

Author URI: http://infolific.com/technology/

License: GPLv2 or later

Text Domain: real-time-find-and-replace

*/



/*

Copyright 2015 Marios Alexandrou



This program is free software; you can redistribute it and/or

modify it under the terms of the GNU General Public License

as published by the Free Software Foundation; either version 2

of the License, or (at your option) any later version.



This program is distributed in the hope that it will be useful,

but WITHOUT ANY WARRANTY; without even the implied warranty of

MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

GNU General Public License for more details.



You should have received a copy of the GNU General Public License

along with this program; if not, write to the Free Software

Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/



//Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



define( 'EDD_RTFR_STORE_URL', 'http://infolific.com' );

define( 'EDD_RTFR_PLUGIN_NAME', 'Real-Time Find and Replace Pro for WordPress' );



if( !class_exists( 'EDD_SL_Plugin_Updater' ) ) {

	include_once( dirname( __FILE__ ) . '/inc/EDD_SL_Plugin_Updater.php' );

}



function far_edd_sl_plugin_updater() {

	$license_key = trim( get_option( 'far_edd_license_key' ) );



	$edd_updater = new EDD_SL_Plugin_Updater( EDD_RTFR_STORE_URL, __FILE__, array(

			'version' 	=> '4.0.3',					// current version number

			'license' 	=> $license_key,			// license key (used get_option above to retrieve from DB)

			'item_name' => EDD_RTFR_PLUGIN_NAME, 	// name of this plugin

			'author' 	=> 'Marios Alexandrou'		// author of this plugin

		)

	);



}

add_action( 'admin_init', 'far_edd_sl_plugin_updater', 0 );



function far_edd_register_option() {

	// creates our settings in the options table

	register_setting('far_edd_license', 'far_edd_license_key', 'far_edd_sanitize_license' );

}

add_action('admin_init', 'far_edd_register_option');



function far_edd_sanitize_license( $new ) {

	$old = get_option( 'far_edd_license_key' );

	if( $old && $old != $new ) {

		delete_option( 'far_edd_license_status' ); // new license has been entered, so must reactivate

	}

	return $new;

}



function far_edd_activate_license() {

	if( isset( $_POST['far_edd_license_activate'] ) ) {

	 	if( ! check_admin_referer( 'far_edd_nonce', 'far_edd_nonce' ) ) {

			return; // get out if we didn't click the Activate button

		}

		

		$license = trim( get_option( 'far_edd_license_key' ) );



		// data to send in our API request

		$api_params = array(

			'edd_action'=> 'activate_license',

			'license' 	=> $license,

			'item_name' => urlencode( EDD_RTFR_PLUGIN_NAME ),

			'url'       => home_url()

		);



		// Call the custom API.

		$response = wp_remote_post( EDD_RTFR_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );



		// make sure the response came back okay

		if ( is_wp_error( $response ) )

			return false;



		$license_data = json_decode( wp_remote_retrieve_body( $response ) );



		// $license_data->license will be either "valid" or "invalid"

		update_option( 'far_edd_license_status', $license_data->license );

	}

}

add_action('admin_init', 'far_edd_activate_license');



function far_edd_deactivate_license() {

	if( isset( $_POST['far_edd_license_deactivate'] ) ) {



	 	if( ! check_admin_referer( 'far_edd_nonce', 'far_edd_nonce' ) ) {

			return; // get out if we didn't click the Activate button

		}

			

		$license = trim( get_option( 'far_edd_license_key' ) );



		// data to send in our API request

		$api_params = array(

			'edd_action'=> 'deactivate_license',

			'license' 	=> $license,

			'item_name' => urlencode( EDD_RTFR_PLUGIN_NAME ),

			'url'       => home_url()

		);



		// Call the custom API.

		$response = wp_remote_post( EDD_RTFR_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );



		// make sure the response came back okay

		if ( is_wp_error( $response ) )

			return false;



		$license_data = json_decode( wp_remote_retrieve_body( $response ) );



		// $license_data->license will be either "deactivated" or "failed"

		if( $license_data->license == 'deactivated' ) {

			delete_option( 'far_edd_license_status' );

		}

	}

}

add_action('admin_init', 'far_edd_deactivate_license');



function far_edd_check_license() {

	global $wp_version;



	$license = trim( get_option( 'far_edd_license_key' ) );



	$api_params = array(

		'edd_action' => 'check_license',

		'license' => $license,

		'item_name' => urlencode( EDD_RTFR_PLUGIN_NAME ),

		'url'       => home_url()

	);



	// Call the custom API.

	$response = wp_remote_post( EDD_RTFR_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );



	if ( is_wp_error( $response ) )

		return false;



	$license_data = json_decode( wp_remote_retrieve_body( $response ) );



	if( $license_data->license == 'valid' ) {

		return true;

	} else {

		return false;

	}

}



function far_plugin_meta( $links, $file ) { // add some links to plugin meta row

	if ( strpos( $file, 'real-time-find-and-replace-pro.php' ) !== false ) {

		$links = array_merge( $links, array( '<a href="' . esc_url( get_admin_url(null, 'tools.php?page=real-time-find-and-replace') ) . '">Settings</a>' ) );

	}

	return $links;

}



/*

* Add a submenu under Tools

*/

function far_add_pages() {

	$page = add_submenu_page( 'tools.php', 'Real-Time Find and Replace Pro', 'Real-Time Find and Replace Pro', 'activate_plugins', 'real-time-find-and-replace', 'far_options_page' );

	add_action( "admin_print_scripts-$page", "far_admin_scripts" );

}



function far_options_page() {



	if ( isset( $_POST['setup-update'] ) && isset( $_POST['submit-import'] ) ) {

        check_admin_referer( 'far_rules_form' );



		/* using decode due to serialize/unserialize bug */

		//update_option( 'far_plugin_settings', stripslashes_deep(unserialize( preg_replace('!s:(\d+):"(.*?)";!se', "'s:'.strlen('$2').':\"$2\";'", base64_decode( $_POST['import-text'] ) ) ) ) );

		update_option( 'far_plugin_settings', unserialize( base64_decode( $_POST['import-text'] ) ) );



		echo '<div id="message" class="updated fade">';

		echo '<p><strong>Options Imported</strong></p>';

		echo '</div>';



	} else if ( isset( $_POST['setup-update'] ) ) {

        check_admin_referer( 'far_rules_form' );



        $_POST = stripslashes_deep( $_POST );

		

		// If atleast one find has been submitted

		if ( isset ( $_POST['farfind'] ) && is_array( $_POST['farfind'] ) ) { 

			foreach ( $_POST['farfind'] as $key => $find ){



				// If empty ones have been submitted we get rid of the extra data submitted if any.

				if ( empty($find) ){ 

					unset( $_POST['farfind'][$key] );

					unset( $_POST['farreplace'][$key] );

					unset( $_POST['farregex'][$key] );

					unset( $_POST['faradmin'][$key] );

					unset( $_POST['farcaseinsensitive'][$key] );

					unset( $_POST['farquerystring'][$key] );

					unset( $_POST['farreferrer'][$key] );

					unset( $_POST['faruseragent'][$key] );

					unset( $_POST['farposttype'][$key] );

					unset( $_POST['fardescription'][$key] );

				}

				

				// Convert line feeds on non-regex only

				if ( !isset( $_POST['farregex'][$key] ) ) {

					$_POST['farfind'][$key] = str_replace( "\r\n", "\n", $find );

				}

			}

		}

		unset( $_POST['setup-update'] );

		unset( $_POST['import-text'] );

		unset( $_POST['export-text'] );

		unset( $_POST['submit-import'] );

		

		// Delete the option if there are no settings. Keeps the database clean if they aren't using it and uninstalled.

		if( empty( $_POST['farfind'] ) ) {

			delete_option( 'far_plugin_settings' );

		} else {

			update_option( 'far_plugin_settings', $_POST );

		}

		?>

		<div id="message" class="updated fade">

			<p><strong>Options Updated</strong></p>

		</div>

	<?php } else if ( isset( $_POST['far_edd_license_save'] ) ) { ?>

<?php		update_option( 'far_edd_license_key', trim( $_POST['far_edd_license_key'] ) ); ?>

		

		

<?php } ?>



<div class="wrap" style="padding-bottom:5em">

	<h2>Real-Time Find and Replace Pro</h2>

	<p>Click "Add" to begin. Then enter your find and replace cases below. Click and drag to change the order. </p>

	<p>Warning: If you expect to have 100+ rules, consider increasing the value of the max_input_vars setting in your php.ini file.</p>

	<div id="far-items">



		<form method="post" action="<?php echo esc_url( $_SERVER["REQUEST_URI"] ); ?>">

            <?php wp_nonce_field( 'far_rules_form' ); ?>

			<?php if ( far_edd_check_license() ) { ?>

			<input type="button" class="button left" value="Add" onClick="addFormField(); return false;" />

			<?php } else { ?>

			<input type="button" class="button left" value="Add" onClick="alert( 'Please buy/activate a license for this plugin.' ); return false;" />

			<?php } ?>

			<input type="submit" class="button left" value="Update Settings" name="update" id="update" />

			<input type="button" class="button left" value="Export Settings" name="export" id="export" onclick="javascript: document.getElementById('export-div').style.display = 'inline'; return false;" />

			<input type="button" class="button left" value="Import Settings" name="import" id="import" onclick="javascript: document.getElementById('import-div').style.display = 'inline'; return false;" />

			<input type="hidden" name="setup-update" />

			<br style="clear: both;" />

			<?php $far_settings = get_option( 'far_plugin_settings' ); ?>

			<div id="export-div" style="display: none; width: 743px; height: 90px;">

				<br />

				Your current settings are below. Make sure you've saved since your latest rule changes.

				<br />

				<textarea style="width: 743px; height: 90px;" id="export-text" name="export-text"><?php /* using decode due to serialize/unserialize bug */ echo ( base64_encode( serialize( $far_settings ) ) ); ?></textarea>

				<br />

			</div>

			<div id="import-div" style="display: none; width: 743px; height: 90px;">

				<br />

				Paste the settings into the box below. Click Submit Import to save.

				<br />

				<textarea style="width: 743px; height: 90px;" id="import-text" name="import-text"></textarea>

				<br />

				<input type="submit" class="button left" value="Submit Import" name="submit-import" id="submit-import" />

			</div>

			<ul id="far_itemlist">

			<?php

				$i = 0;



				// If there are any finds already set

				if ( isset ( $far_settings['farfind'] ) && is_array( $far_settings['farfind'] ) ){

					$i = 1;

					foreach ( $far_settings['farfind'] as $key => $find ){

						if( isset( $far_settings['farregex'][$key] ) ) {

							$regex_checked = 'CHECKED';

						} else {

							$regex_checked = '';

						}



						if( isset( $far_settings['faradmin'][$key] ) ) {

							$admin_checked = 'CHECKED';

						} else {

							$admin_checked = '';

						}



						if( isset( $far_settings['farcaseinsensitive'][$key] ) ) {

							$caseinsensitive_checked = 'CHECKED';

						} else {

							$caseinsensitive_checked = '';

						}



						if ( isset( $far_settings['farreplace'][$key] ) ) {

							$far_replace = $far_settings['farreplace'][$key];

						} else {

							$far_replace = '';

						}

						

						if ( isset( $far_settings['fardescription'][$key] ) ) {

							$far_description = $far_settings['fardescription'][$key];						

						} else {

							$far_description = '';

						}



						if ( strlen( trim( $far_description ) ) == 0 ) {

							$far_description = 'notes';							

						}



						if ( isset( $far_settings['farquerystring'][$key] ) ) {

							$far_querystring = $far_settings['farquerystring'][$key];						

						} else {

							$far_querystring = '';

						}

						

						if ( isset( $far_settings['farreferrer'][$key] ) ) {

							$far_referrer = $far_settings['farreferrer'][$key];

						} else {

							$far_referrer = '';

						}



						if ( isset( $far_settings['faruseragent'][$key] ) ) {

							$far_useragent = $far_settings['faruseragent'][$key];

						} else {

							$far_useragent = '';

						}



						if ( isset( $far_settings['farposttype'][$key] ) ) {

							$far_post_type = $far_settings['farposttype'][$key];

						} else {

							$far_post_type = '';

						}



						echo "<li id='row$i'>";



						echo "<div style='float: left'>";

							echo "<div style='float: left'>";

							echo "<label for='farfind$i'>Find:</label>";

							echo "<br />";

							echo "<textarea class='left' name='farfind[$i]' id='farfind$i'>" . esc_textarea( $find ) . "</textarea>";

							echo "</div>";



							echo "<div style='float: left'>";

							echo "<label for='farreplace$i'>Replace With:</label>";

							echo "<br />";

							echo "<textarea class='left' name='farreplace[$i]' id='farreplace$i'>" . esc_textarea( $far_replace ) . "</textarea>";

							echo "</div>";

						echo "</div>";



						echo "<div style='float: left'>";

							echo "<label class='side-label' for='farregex$i'>Use RegEx:</label>";

							echo "<input class='checkbox' type='checkbox' name='farregex[$i]' id='farregex$i' $regex_checked />";

							echo "&nbsp;&nbsp;";

							echo "<label class='side-label-long' for='faradmin$i'>Admin:&nbsp;</label>";

							echo "<input class='checkbox' type='checkbox' name='faradmin[$i]' id='faradmin$i' $admin_checked />";

							echo "&nbsp;&nbsp;";

							echo "<label class='side-label-long' for='faradmin$i'>Ignore Case:&nbsp;</label>";

							echo "<input class='checkbox' type='checkbox' name='farcaseinsensitive[$i]' id='farcaseinsensitive$i' $caseinsensitive_checked />";

							echo "<br />";



							echo "<label class='side-label' for='farposttype$i'>Post Type:</label>";

							$args = array(

							   'public'   => true,

							);

							$post_types = get_post_types( $args, "names", "and" ); 

							$post_types_dropdown = "<select name='farposttype[$i]' id='farposttype$i'>";

							$post_types_dropdown = $post_types_dropdown . "<option value='any'>any</option>";

							foreach ( $post_types as $post_type ) {

								if( $far_post_type == $post_type ) {

									$post_types_dropdown = $post_types_dropdown . "<option value='$post_type' selected>" . $post_type . "</option>";

								} else {

									$post_types_dropdown = $post_types_dropdown . "<option value='$post_type'>" . $post_type . "</option>";

								}

							}

							$post_types_dropdown = $post_types_dropdown . '</select>';

							echo $post_types_dropdown;

							echo "<br />";



							echo "<label class='side-label' for='farquerystring$i'>Querystring:</label>";

							echo "<input class='textbox' type='text' name='farquerystring[$i]' id='farquerystring$i' value='" . esc_textarea( $far_querystring ) . "' />";

							echo "<br />";



							echo "<label class='side-label' for='farreferrer$i'>Referrer:</label>";

							echo "<input class='textbox' type='text' name='farreferrer[$i]' id='farreferrer$i' value='" . esc_textarea( $far_referrer ) . "' />";

							echo "<br />";



							echo "<label class='side-label' for='faruseragent$i'>User Agent:</label>";

							echo "<input class='textbox' type='text' name='faruseragent[$i]' id='faruseragent$i' value='" . esc_textarea( $far_useragent ) . "' />";

							echo "<br />";



						echo "</div>";



						echo "<div>";

							echo "<input style='width: 615px;"; 

							if ( strcasecmp( $far_description, 'notes' ) === 0 ) { 

								echo (" color: #cccccc;");

							}

							echo "' type='text' name='fardescription[$i]' id='fardescription$i' value='" . esc_textarea( $far_description ) . "' />";

							echo "<input style='margin-right: 9px' type='button' class='button right remove' value='Remove' onClick='removeFormField(\"#row$i\"); return false;' />";

						echo "</div>";



						echo "</li>";

						unset($regex_checked);

						$i = $i + 1;

					}

				} else {

					// Do nothing

				}

				?>

			</ul>

			<div id="divTxt"></div>

		    <div class="clearpad"></div>

			<?php if ( far_edd_check_license() ) { ?>

			<input type="button" class="button left" value="Add" onClick="addFormField(); return false;" />

			<?php } else { ?>

			<input type="button" class="button left" value="Add" onClick="alert( 'Please buy/activate a license for this plugin. A license is required per domain other than localhost.' ); return false;" />

			<?php } ?>

			<input type="submit" class="button left" value="Update Settings" />

		 	<input type="hidden" id="id" value="<?php echo $i; /* used so javascript returns unique ids */ ?>" />

		</form>

	</div>



	<div id="far-sb">

		<div class="postbox" id="far-sbzero">

			<h3 class="hndle"><span>License</span></h3>

			<div class="inside">

				<?php

				$license 	= get_option( 'far_edd_license_key' );

				$status 	= get_option( 'far_edd_license_status' );

				?>

				<div class="wrap">

					<form method="post" action="<?php echo esc_url( $_SERVER["REQUEST_URI"] ); ?>">

						<?php settings_fields('far_edd_license'); ?>

						<input class="textbox-sidebar" id="far_edd_license_key" name="far_edd_license_key" type="text" value="<?php esc_attr_e( $license ); ?>" />

						<div id="license-buttons" style="display: inline-block; padding-top: 5px;">

							<div style="float: left;">

								<input type="submit" class="button" name="far_edd_license_save" value="Save License"/>

							</div>

							<div style="float: left;">

								<?php if( false !== $license ) { ?>

									<?php if( $status !== false && $status == 'valid' ) {

										wp_nonce_field( 'far_edd_nonce', 'far_edd_nonce' ); ?>

										<input type="submit" class="button" name="far_edd_license_deactivate" value="<?php _e('Deactivate License'); ?>"/>

									<?php } else {

										wp_nonce_field( 'far_edd_nonce', 'far_edd_nonce' ); ?>

										<input type="submit" class="button" name="far_edd_license_activate" value="<?php _e('Activate License'); ?>"/>

									<?php } ?>

								<?php } ?>

							</div>

						</div>

					</form>

				</div>

			</div>

		</div>

		<div class="postbox" id="far-sbone">

			<h3 class="hndle"><span>Documentation</span></h3>

			<div class="inside">

				<strong>Instructions</strong>

				<p>This plugin will replace HTML code AFTER it is written by the WordPress engine, but before it is sent to a user's browser. None of these changes affect your files. To undo changes, just delete the find/replace pair.</p>

				<ol>

	            <li>Type in text/code to find on the left. This can be a plain text match or a regular expression (use / at the start and end).</li>

				<li>Type in the text/code you want to replace the find with on the right.</li>

				<li>If using a regular expression for the find, check the Use RegEx box.</li>

				<li>To make the rule apply to admin pages as well (not recommended), check the Admin box. Note that no rules will execute on this plugin's page as that will cause problems.</li>

				<li>For non-regex searches, you can ignore case by checking the Ignore Case box.</li>

				<li>You can further control when the replace occurs by specifying a post type that must match.</li>

				<li>In addition, you can specify a querytring, referrer, and useragent to match. Note that these filters perform a simple "contains" for the text given.</li>

				<li>The notes field is to help with organizing and describing your rules. It doesn't affect the matching process.</li>

				</ol>

				<strong>Tips</strong>

				<ol>

	            <li>Want to remove text/code from a page? Leave the replace box blank.</li>

				<li>Want to disable a rule, but not delete it? Put something random in the match box that will not actually be matched.</li>

				<li>Not seeing your changes? Turn off your cache!</li>

				<li>Seeing a blank page on your site? Incorrect regex syntax is the most common cause.</li>

				<li>Need some ideas? <a href="http://infolific.com/technology/internet/handiest-wordpress-plugin-youve-never-heard-of/">Check out this post.</a></li>

				</ol>

			</div>

		</div>

		<div class="postbox" id="far-sbtwo">

			<h3 class="hndle"><span>Support</span></h3>

			<div class="inside">

				<p>Your best bet is to post on the <a href="http://infolific.com/technology/software-worth-using/real-time-find-and-replace-for-wordpress/#pro-version">support page</a> for the pro version.</p>

				<p>Please consider supporting me by <a href="https://wordpress.org/support/view/real-time-find-and-replace">rating this plugin</a>. Thanks!</p>

			</div>

		</div>

		<div class="postbox" id="far-sbthree">

			<h3 class="hndle"><span>Other Plugins</span></h3>

			<div class="inside">

				<ul>

					<li><a href="https://wordpress.org/plugins/real-time-find-and-replace/">Real-Time Find and Replace</a>: Set up find and replace rules that are executed AFTER a page is generated by WordPress, but BEFORE it is sent to a user's browser.</li>

					<li><a href="https://wordpress.org/plugins/republish-old-posts/">Republish Old Posts</a>: Republish old posts automatically by resetting the date to the current date. Puts your evergreen posts back in front of your users.</li>

					<li><a href="https://wordpress.org/extend/plugins/rss-includes-pages/">RSS Includes Pages</a>: Modifies RSS feeds so that they include pages and not just posts. My most popular plugin!</li>

					<li><a href="https://wordpress.org/extend/plugins/enhanced-plugin-admin">Enhanced Plugin Admin</a>: At-a-glance info (rating, review count, last update date) on your site's plugin page about the plugins you have installed (both active and inactive).</li>

					<li><a href="https://wordpress.org/extend/plugins/add-any-extension-to-pages/">Add Any Extention to Pages</a>: Add any extension of your choosing (e.g. .html, .htm, .jsp, .aspx, .cfm) to WordPress pages.</li>

					<li><a href="https://wordpress.org/extend/plugins/social-media-email-alerts/">Social Media E-Mail Alerts</a>: Receive e-mail alerts when your site gets traffic from social media sites of your choosing. You can also set up alerts for when certain parameters appear in URLs.</li>				</ul>

				</ul>

			</div>

		</div>

	</div>

</div>

<?php } ?>

<?php

/*

* Scripts needed for the admin side

*/

function far_admin_scripts() {

	wp_enqueue_script( 'far_dynamicfields', plugins_url() . '/real-time-find-and-replace-pro/js/jquery.dynamicfields.js', array('jquery') );

	wp_enqueue_script( 'jquery-ui-1', plugins_url() . '/real-time-find-and-replace-pro/js/jquery-ui-1.10.3.custom.min.js', array('jquery') );

	wp_enqueue_style( 'far_styles', plugins_url() . '/real-time-find-and-replace-pro/css/far.css' );

}



/*

* Apply find and replace rules

*/

function far_ob_call($buffer) { // $buffer contains entire page



	$current_querystring = $_SERVER['REQUEST_URI'];

	$current_referrer = isset( $_SERVER['HTTP_REFERER'] ) ? $_SERVER['HTTP_REFERER'] : 'none';

	$current_useragent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? $_SERVER['HTTP_USER_AGENT'] : 'none';

	$current_post_type = get_post_type();



	//A filter to consider in the future

	//$current_post_type = get_post_type();

	//A filter to consider in the future

	//$current_page_template = get_page_template();



	/* Debug messages for use during development

	$far_debug = "\n";

	$far_debug = $far_debug . "<!--\n";

	$far_debug = $far_debug . "querystring: " . $current_querystring . "\n";

	$far_debug = $far_debug . "referrer: " . $current_referer . "\n";

	$far_debug = $far_debug . "useragent: " . $current_useragent . "\n";

	$far_debug = $far_debug . "post type: " . $current_post_type . "\n";

	$far_debug = $far_debug . "page template: " . $current_page_template . "\n";

	$far_debug = $far_debug . "-->\n";

	*/



	$far_settings = get_option( 'far_plugin_settings' );

	if ( is_array( $far_settings['farfind'] ) ) {

		foreach ( $far_settings['farfind'] as $key => $find ) {



			//Make sure we don't find and replace on this plugin's page as that could cause a errors with the settings.

			if ( is_admin() && substr_count( $_SERVER["REQUEST_URI"], 'real-time-find-and-replace') > 0 ) {

				//Don't find and replace

			} else {



				//On admin page and rule set to execute on admin page

				if( is_admin() && isset( $far_settings['faradmin'][$key] ) ) {

					if( isset( $far_settings['farregex'][$key] ) ) {

						if ( ( empty( $far_settings['farquerystring'][$key] ) || FALSE !== strpos( $current_querystring, $far_settings['farquerystring'][$key] ) ) &&

							 ( empty( $far_settings['farreferrer'][$key] ) || FALSE !== strpos( $current_referrer, $far_settings['farreferrer'][$key] ) ) &&

							 ( empty( $far_settings['faruseragent'][$key] ) || FALSE !== strpos( $current_useragent, $far_settings['faruseragent'][$key] ) ) &&

							 ( empty( $far_settings['farposttype'][$key] ) || 0 === strcasecmp( $current_post_type, $far_settings['farposttype'][$key] ) || 0 === strcasecmp( "any", $far_settings['farposttype'][$key] ) )

							) {

								$buffer = preg_replace( $find, $far_settings['farreplace'][$key], $buffer );

						}

					} else {			

						if ( ( empty( $far_settings['farquerystring'][$key] ) || FALSE !== strpos( $current_querystring, $far_settings['farquerystring'][$key] ) ) &&

							 ( empty( $far_settings['farreferrer'][$key] ) || FALSE !== strpos( $current_referrer, $far_settings['farreferrer'][$key] ) ) &&

							 ( empty( $far_settings['faruseragent'][$key] ) || FALSE !== strpos( $current_useragent, $far_settings['faruseragent'][$key] ) ) &&

							 ( empty( $far_settings['farposttype'][$key] ) || 0 === strcasecmp( $current_post_type, $far_settings['farposttype'][$key] ) || 0 === strcasecmp( "any", $far_settings['farposttype'][$key] ) )

							) {

								if( isset( $far_settings['farcaseinsensitive'][$key] ) ) {

									$buffer = str_ireplace( $find, $far_settings['farreplace'][$key], $buffer );

								} else {

									$buffer = str_replace( $find, $far_settings['farreplace'][$key], $buffer );

								}

						}

					}



				//Not on admin page so execute rule

				} else if ( !is_admin() ) {

					if( isset( $far_settings['farregex'][$key] ) ) {

						if ( ( empty( $far_settings['farquerystring'][$key] ) || FALSE !== strpos( $current_querystring, $far_settings['farquerystring'][$key] ) ) &&

							 ( empty( $far_settings['farreferrer'][$key] ) || FALSE !== strpos( $current_referrer, $far_settings['farreferrer'][$key] ) ) &&

							 ( empty( $far_settings['faruseragent'][$key] ) || FALSE !== strpos( $current_useragent, $far_settings['faruseragent'][$key] ) ) &&

							 ( empty( $far_settings['farposttype'][$key] ) || 0 === strcasecmp( $current_post_type, $far_settings['farposttype'][$key] ) || 0 === strcasecmp( "any", $far_settings['farposttype'][$key] ) )

							) {

								$buffer = preg_replace( $find, $far_settings['farreplace'][$key], $buffer );

						}

					} else {			

						if ( ( empty( $far_settings['farquerystring'][$key] ) || FALSE !== strpos( $current_querystring, $far_settings['farquerystring'][$key] ) ) &&

							 ( empty( $far_settings['farreferrer'][$key] ) || FALSE !== strpos( $current_referrer, $far_settings['farreferrer'][$key] ) ) &&

							 ( empty( $far_settings['faruseragent'][$key] ) || FALSE !== strpos( $current_useragent, $far_settings['faruseragent'][$key] ) ) &&

							 ( empty( $far_settings['farposttype'][$key] ) || 0 === strcasecmp( $current_post_type, $far_settings['farposttype'][$key] ) || 0 === strcasecmp( "any", $far_settings['farposttype'][$key] ) )

							) {

								if( isset( $far_settings['farcaseinsensitive'][$key] ) ) {

									$buffer = str_ireplace( $find, $far_settings['farreplace'][$key], $buffer );

								} else {

									$buffer = str_replace( $find, $far_settings['farreplace'][$key], $buffer );

								}

						}

					}

				}

			}

		}

	}

	return $buffer;

}



//Find and Replace on public-facing pages

function far_template_redirect() {

	ob_start();

	ob_start( 'far_ob_call' );

}



//Find and Replace on admin pages

function far_admin_init() {

	ob_start();

	ob_start( 'far_ob_call' );

}



//Add left menu item in admin

add_action('admin_menu', 'far_add_pages');



//Add additional links below plugin description on plugin page

add_filter('plugin_row_meta', 'far_plugin_meta', 10, 2);



//Handles find and replace for admin pages

add_action( 'admin_init', 'far_admin_init' );



//Handles find and replace for public pages

add_action( 'template_redirect', 'far_template_redirect' );



//Handles find and replace for login page

add_action( 'login_headertext', 'far_admin_init' );